/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.hamiltonian.minecraft.wiki.WikiConfig;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");
    private static final Gson GSON = new Gson();
    private final WikiConfig config;
    private final HttpClient httpClient;

    public WikiApiClient(WikiConfig config) {
        this.config = config;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public CompletableFuture<RegisterTokenResult> registerToken(String minecraftUuid, String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject body = new JsonObject();
                body.addProperty("minecraftUuid", minecraftUuid);
                body.addProperty("username", username);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getWikiUrl() + "/api/auth/register-token")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.config.getServerToken()).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)body))).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                    String loginUrl = json.get("loginUrl").getAsString();
                    String clientToken = json.has("clientToken") ? json.get("clientToken").getAsString() : null;
                    String wikiUrl = json.has("wikiUrl") ? json.get("wikiUrl").getAsString() : this.config.getWikiUrl();
                    return new RegisterTokenResult(true, loginUrl, clientToken, wikiUrl, null);
                }
                if (response.statusCode() == 401) {
                    return new RegisterTokenResult(false, null, null, null, "Server not authorized. Please run /wiki link first.");
                }
                LOGGER.error("API error: {} - {}", (Object)response.statusCode(), (Object)response.body());
                return new RegisterTokenResult(false, null, null, null, "Wiki API error: " + response.statusCode());
            }
            catch (Exception e) {
                LOGGER.error("Failed to register token", (Throwable)e);
                return new RegisterTokenResult(false, null, null, null, "Failed to connect to wiki: " + e.getMessage());
            }
        });
    }

    public CompletableFuture<LinkServerResult> linkServer(String serverName, String adminUuid, String adminUsername) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject body = new JsonObject();
                body.addProperty("serverName", serverName);
                body.addProperty("adminMinecraftUuid", adminUuid);
                body.addProperty("adminUsername", adminUsername);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getWikiUrl() + "/api/server/link")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)body))).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                    String token = json.get("serverToken").getAsString();
                    return new LinkServerResult(true, token, null);
                }
                LOGGER.error("Link API error: {} - {}", (Object)response.statusCode(), (Object)response.body());
                return new LinkServerResult(false, null, "Failed to link server: " + response.statusCode());
            }
            catch (Exception e) {
                LOGGER.error("Failed to link server", (Throwable)e);
                return new LinkServerResult(false, null, "Failed to connect to wiki: " + e.getMessage());
            }
        });
    }

    public CompletableFuture<SetupServerResult> setupServer(String setupToken, String adminUuid, String adminUsername) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject body = new JsonObject();
                body.addProperty("setupToken", setupToken);
                body.addProperty("adminMinecraftUuid", adminUuid);
                body.addProperty("adminUsername", adminUsername);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getWikiUrl() + "/api/server/setup")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)body))).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                    String token = json.get("serverToken").getAsString();
                    String loginUrl = json.has("loginUrl") ? json.get("loginUrl").getAsString() : null;
                    return new SetupServerResult(true, token, loginUrl, null);
                }
                if (response.statusCode() == 401) {
                    return new SetupServerResult(false, null, null, "Invalid or expired setup token. Restart the wiki server to get a new token.");
                }
                LOGGER.error("Setup API error: {} - {}", (Object)response.statusCode(), (Object)response.body());
                return new SetupServerResult(false, null, null, "Failed to setup server: " + response.statusCode());
            }
            catch (Exception e) {
                LOGGER.error("Failed to setup server", (Throwable)e);
                return new SetupServerResult(false, null, null, "Failed to connect to wiki: " + e.getMessage());
            }
        });
    }

    public CompletableFuture<ShareUrlResult> getShareUrl(String minecraftUuid, String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject body = new JsonObject();
                body.addProperty("minecraftUuid", minecraftUuid);
                body.addProperty("username", username);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getWikiUrl() + "/api/auth/share-token")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.config.getServerToken()).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)body))).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                    String shareUrl = json.get("shareUrl").getAsString();
                    return new ShareUrlResult(true, shareUrl, null);
                }
                if (response.statusCode() == 401) {
                    return new ShareUrlResult(false, null, "Server not authorized. Please run /wiki link first.");
                }
                LOGGER.error("Share URL API error: {} - {}", (Object)response.statusCode(), (Object)response.body());
                return new ShareUrlResult(false, null, "Wiki API error: " + response.statusCode());
            }
            catch (Exception e) {
                LOGGER.error("Failed to get share URL", (Throwable)e);
                return new ShareUrlResult(false, null, "Failed to connect to wiki: " + e.getMessage());
            }
        });
    }

    public record ShareUrlResult(boolean success, String shareUrl, String error) {
    }

    public record SetupServerResult(boolean success, String serverToken, String loginUrl, String error) {
    }

    public record LinkServerResult(boolean success, String serverToken, String error) {
    }

    public record RegisterTokenResult(boolean success, String loginUrl, String clientToken, String wikiUrl, String error) {
    }
}

