/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.hamiltonian.minecraft.wiki.WikiConfig;
import io.hamiltonian.minecraft.wiki.WikiPlugin;
import io.hamiltonian.minecraft.wiki.network.WikiNetworkingServer;
import java.net.URI;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class WikiCommands {
    private static final class_12087 OWNER_PERMISSION = new class_12087.class_12089(class_12094.field_63200);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wiki").executes(WikiCommands::wikiLogin)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"link").requires(source -> source.method_75037().hasPermission(OWNER_PERMISSION))).then(class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(WikiCommands::wikiLink)))).then(class_2170.method_9247((String)"share").executes(WikiCommands::wikiShare))).then(class_2170.method_9247((String)"help").executes(WikiCommands::wikiHelp)));
    }

    private static int wikiLogin(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player."));
            return 0;
        }
        class_3222 player = source.method_44023();
        WikiPlugin plugin = WikiPlugin.getInstance();
        WikiConfig config = plugin.getConfig();
        if (!config.isConfigured()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Wiki is not configured. An admin needs to run /wiki link <serverName> first."));
            return 0;
        }
        String uuid = player.method_5667().toString().replace("-", "");
        String username = player.method_5477().getString();
        source.method_9226(() -> class_2561.method_43470((String)"Generating login link...").method_27692(class_124.field_1080), false);
        plugin.getApiClient().registerToken(uuid, username).thenAccept(result -> {
            if (result.success()) {
                try {
                    URI loginUri = URI.create(result.loginUrl());
                    class_5250 message = class_2561.method_43470((String)"Click here to login to the Wiki").method_27695(new class_124[]{class_124.field_1060, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(loginUri)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to open: " + result.loginUrl())))));
                    player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)message));
                    player.method_64398((class_2561)class_2561.method_43470((String)"This link expires in 5 minutes.").method_27692(class_124.field_1080));
                    if (result.clientToken() != null && result.wikiUrl() != null) {
                        WikiNetworkingServer.sendClientToken(player, result.wikiUrl(), result.clientToken());
                    }
                }
                catch (IllegalArgumentException e) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"Invalid login URL").method_27692(class_124.field_1061)));
                }
            } else {
                player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)result.error()).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int wikiLink(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String args = StringArgumentType.getString(context, (String)"args");
        String[] parts = args.split(" ", 2);
        if (parts.length != 2) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Usage: /wiki link <url> <token>"));
            return 0;
        }
        String url = parts[0].trim();
        String token = parts[1].trim();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player."));
            return 0;
        }
        class_3222 player = source.method_44023();
        WikiPlugin plugin = WikiPlugin.getInstance();
        WikiConfig config = plugin.getConfig();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        config.setWikiUrl(url);
        String uuid = player.method_5667().toString().replace("-", "");
        String username = player.method_5477().getString();
        source.method_9226(() -> class_2561.method_43470((String)"Setting up wiki connection...").method_27692(class_124.field_1080), false);
        plugin.getApiClient().setupServer(token, uuid, username).thenAccept(result -> {
            if (result.success()) {
                config.setServerToken(result.serverToken());
                config.save();
                player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Server linked successfully!").method_27692(class_124.field_1060)));
                player.method_64398((class_2561)class_2561.method_43470((String)"You are now a wiki admin.").method_27692(class_124.field_1080));
                if (result.loginUrl() != null) {
                    try {
                        URI loginUri = URI.create(result.loginUrl());
                        class_5250 loginMessage = class_2561.method_43470((String)"Click here to login to the Wiki").method_27695(new class_124[]{class_124.field_1060, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(loginUri)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to open: " + result.loginUrl())))));
                        player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)loginMessage));
                        player.method_64398((class_2561)class_2561.method_43470((String)"This link expires in 5 minutes.").method_27692(class_124.field_1080));
                    }
                    catch (IllegalArgumentException e) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"Run /wiki to get a login link.").method_27692(class_124.field_1080));
                    }
                }
            } else {
                player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)result.error()).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int wikiShare(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player."));
            return 0;
        }
        class_3222 player = source.method_44023();
        WikiPlugin plugin = WikiPlugin.getInstance();
        WikiConfig config = plugin.getConfig();
        if (!config.isConfigured()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Wiki is not configured. An admin needs to run /wiki link first."));
            return 0;
        }
        String uuid = player.method_5667().toString().replace("-", "");
        String username = player.method_5477().getString();
        plugin.getApiClient().getShareUrl(uuid, username).thenAccept(result -> {
            if (result.success()) {
                try {
                    URI shareUri = URI.create(result.shareUrl());
                    class_5250 message = class_2561.method_43470((String)"Click here to share a screenshot").method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(shareUri)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Opens the wiki to upload a screenshot"))));
                    player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)message));
                    player.method_64398((class_2561)class_2561.method_43470((String)"The file picker will open automatically.").method_27692(class_124.field_1080));
                }
                catch (IllegalArgumentException e) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"Failed to generate share link").method_27692(class_124.field_1061)));
                }
            } else {
                player.method_64398((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)result.error()).method_27692(class_124.field_1061)));
            }
        });
        return 1;
    }

    private static int wikiHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Wiki Plugin Help ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"/wiki").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" - Get a login link for the wiki").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)"/wiki share").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" - Share a screenshot to the wiki").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)"/wiki link <url> <token>").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" - Link to wiki using setup token (admin)").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)"/wiki help").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" - Show this help").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> class_2561.method_43470((String)"Tip: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"If links don't open, enable ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Options \u2192 Chat Settings \u2192 Web Links").method_27692(class_124.field_1068)), false);
        return 1;
    }
}

