/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");
    private static final String CONFIG_FILE = "wiki-plugin.properties";
    private String wikiUrl = "http://localhost:5229";
    private String serverToken = "";
    private final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("wiki-plugin.properties");

    public void load() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.save();
            return;
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(this.configPath, new OpenOption[0]);){
            props.load(in);
            this.wikiUrl = props.getProperty("wiki_url", this.wikiUrl);
            this.serverToken = props.getProperty("server_token", this.serverToken);
            LOGGER.info("Loaded config from {}", (Object)this.configPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    public void save() {
        Properties props = new Properties();
        props.setProperty("wiki_url", this.wikiUrl);
        props.setProperty("server_token", this.serverToken);
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(this.configPath, new OpenOption[0]);){
                props.store(out, "Wiki Plugin Configuration");
            }
            LOGGER.info("Saved config to {}", (Object)this.configPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public String getWikiUrl() {
        return this.wikiUrl;
    }

    public void setWikiUrl(String wikiUrl) {
        this.wikiUrl = wikiUrl;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public void setServerToken(String serverToken) {
        this.serverToken = serverToken;
    }

    public boolean isConfigured() {
        return this.serverToken != null && !this.serverToken.isEmpty();
    }
}

