/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki;

import com.mojang.brigadier.CommandDispatcher;
import io.hamiltonian.minecraft.wiki.WikiApiClient;
import io.hamiltonian.minecraft.wiki.WikiCommands;
import io.hamiltonian.minecraft.wiki.WikiConfig;
import io.hamiltonian.minecraft.wiki.network.WikiNetworkingServer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiPlugin
implements ModInitializer {
    public static final String MOD_ID = "wiki-plugin";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");
    private static WikiPlugin instance;
    private WikiConfig config;
    private WikiApiClient apiClient;
    private MinecraftServer server;

    public void onInitialize() {
        instance = this;
        LOGGER.info("Wiki Plugin initializing...");
        this.config = new WikiConfig();
        this.config.load();
        this.apiClient = new WikiApiClient(this.config);
        WikiNetworkingServer.register(this.config);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> WikiCommands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            LOGGER.info("Wiki Plugin ready! Use /wiki to get started.");
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.server = null;
        });
    }

    public static WikiPlugin getInstance() {
        return instance;
    }

    public WikiConfig getConfig() {
        return this.config;
    }

    public WikiApiClient getApiClient() {
        return this.apiClient;
    }

    public MinecraftServer getServer() {
        return this.server;
    }
}

