/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.hamiltonian.minecraft.wiki.client.WikiClientState;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ScreenshotHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");
    private static final Gson GSON = new Gson();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static Path pendingScreenshot = null;
    private static long pendingScreenshotTime = 0L;

    public static void onScreenshotTaken(Path screenshotPath) {
        LOGGER.info("Screenshot detected: {}", (Object)screenshotPath.getFileName());
        pendingScreenshot = screenshotPath;
        pendingScreenshotTime = System.currentTimeMillis();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (WikiClientState.isAutoShareEnabled() && WikiClientState.isConfigured()) {
            ScreenshotHandler.uploadScreenshot(screenshotPath, true, false);
            return;
        }
        client.execute(() -> ScreenshotHandler.showShareOption(client));
    }

    private static void showShareOption(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        class_5250 postLink = class_2561.method_43470((String)"[Post Screenshot]").method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/wiki share")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Post screenshot and stay in game"))));
        class_5250 postEditLink = class_2561.method_43470((String)"[Post and Edit]").method_27695(new class_124[]{class_124.field_1060, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/wiki share edit")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Post screenshot and open browser to add a caption"))));
        class_5250 message = class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)postLink).method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(class_124.field_1070)).method_10852((class_2561)postEditLink);
        if (!WikiClientState.hasShownShareTip() && !WikiClientState.hasUsedAutoShareCommand()) {
            WikiClientState.markShareTipShown();
            class_5250 tip = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"Tip: Use ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"/wiki autoshare").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to automatically share all screenshots").method_27692(class_124.field_1080));
            message = message.method_10852((class_2561)tip);
        }
        client.field_1724.method_7353((class_2561)message, false);
    }

    public static void shareLastScreenshot(boolean openBrowser) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (pendingScreenshot == null || !Files.exists(pendingScreenshot, new LinkOption[0])) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"No recent screenshot to share.").method_27692(class_124.field_1054)), false);
            return;
        }
        long age = System.currentTimeMillis() - pendingScreenshotTime;
        if (age > 300000L) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Screenshot too old. Take a new one!").method_27692(class_124.field_1054)), false);
            pendingScreenshot = null;
            return;
        }
        if (!WikiClientState.isConfigured()) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Not connected to wiki. The server must use ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"/wiki link").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" first.").method_27692(class_124.field_1054)), false);
            return;
        }
        Path screenshot = pendingScreenshot;
        pendingScreenshot = null;
        ScreenshotHandler.uploadScreenshot(screenshot, false, openBrowser);
    }

    private static void uploadScreenshot(Path screenshotPath, boolean isAutoUpload, boolean openBrowser) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!isAutoUpload) {
            client.execute(() -> client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Uploading screenshot...").method_27692(class_124.field_1080)), false));
        }
        CompletableFuture.runAsync(() -> {
            block8: {
                try {
                    String filename = screenshotPath.getFileName().toString();
                    byte[] fileBytes = Files.readAllBytes(screenshotPath);
                    String boundary = "----WikiPluginBoundary" + UUID.randomUUID().toString().replace("-", "");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8), true);
                    writer.append("--").append(boundary).append("\r\n");
                    writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(filename).append("\"\r\n");
                    writer.append("Content-Type: image/png\r\n\r\n");
                    writer.flush();
                    baos.write(fileBytes);
                    writer.append("\r\n");
                    writer.append("--").append(boundary).append("--\r\n");
                    writer.flush();
                    byte[] requestBody = baos.toByteArray();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(WikiClientState.getWikiUrl() + "/api/screenshot/upload?createPost=true")).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("Authorization", "Bearer " + WikiClientState.getClientToken()).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).timeout(Duration.ofSeconds(30L)).build();
                    HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 200) {
                        JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                        String editPostUrl = json.has("editPostUrl") ? json.get("editPostUrl").getAsString() : null;
                        client.execute(() -> ScreenshotHandler.showUploadSuccess(client, editPostUrl, isAutoUpload, openBrowser));
                        LOGGER.info("Screenshot uploaded and post created successfully");
                        break block8;
                    }
                    if (response.statusCode() == 401) {
                        client.execute(() -> ScreenshotHandler.showAuthError(client));
                        break block8;
                    }
                    if (response.statusCode() == 429) {
                        JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                        String message = json.has("message") ? json.get("message").getAsString() : "Too many uploads. Please wait before uploading again.";
                        client.execute(() -> ScreenshotHandler.showRateLimitError(client, message));
                        break block8;
                    }
                    LOGGER.error("Screenshot upload failed: {} - {}", (Object)response.statusCode(), (Object)response.body());
                    Object errorMessage = "Upload failed: " + response.statusCode();
                    try {
                        JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                        if (json.has("error")) {
                            errorMessage = json.get("error").getAsString();
                        }
                    }
                    catch (Exception json) {
                        // empty catch block
                    }
                    String finalErrorMessage = errorMessage;
                    client.execute(() -> ScreenshotHandler.showUploadError(client, finalErrorMessage));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to upload screenshot", (Throwable)e);
                    client.execute(() -> ScreenshotHandler.showUploadError(client, e.getMessage()));
                }
            }
        });
    }

    private static void showUploadSuccess(class_310 client, String editPostUrl, boolean isAutoUpload, boolean openBrowser) {
        if (client.field_1724 == null) {
            return;
        }
        if (openBrowser && editPostUrl != null) {
            try {
                class_156.method_668().method_673(URI.create(editPostUrl));
            }
            catch (Exception e) {
                LOGGER.error("Failed to open browser", (Throwable)e);
            }
        }
        if (!isAutoUpload && openBrowser) {
            return;
        }
        if (!isAutoUpload) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Screenshot shared! ").method_27692(class_124.field_1060));
        if (editPostUrl != null) {
            class_5250 editLink = class_2561.method_43470((String)"[Edit Post]").method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(editPostUrl))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to add a caption or edit your post"))));
            message = message.method_10852((class_2561)editLink);
        }
        if (!WikiClientState.hasShownAutoShareTip() && !WikiClientState.hasUsedAutoShareCommand()) {
            WikiClientState.markAutoShareTipShown();
            class_5250 tip = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"Tip: Use ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"/wiki autoshare").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to disable automatic sharing").method_27692(class_124.field_1080));
            message = message.method_10852((class_2561)tip);
        }
        client.field_1724.method_7353((class_2561)message, false);
    }

    private static void showAuthError(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Session expired. Reconnect to the server to get a new token.").method_27692(class_124.field_1054));
        client.field_1724.method_7353((class_2561)message, false);
        WikiClientState.clearSession();
    }

    private static void showRateLimitError(class_310 client, String message) {
        if (client.field_1724 == null) {
            return;
        }
        class_5250 text = class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1054));
        client.field_1724.method_7353((class_2561)text, false);
    }

    private static void showUploadError(class_310 client, String error) {
        if (client.field_1724 == null) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)error).method_27692(class_124.field_1061));
        client.field_1724.method_7353((class_2561)message, false);
    }
}

