/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.hamiltonian.minecraft.wiki.client.ScreenshotHandler;
import io.hamiltonian.minecraft.wiki.client.WikiClientState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class WikiClientCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register(WikiClientCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"wiki").then(ClientCommandManager.literal((String)"autoshare").executes(context -> {
            WikiClientState.markAutoShareCommandUsed();
            boolean newState = WikiClientState.toggleAutoShare();
            String status = newState ? "enabled" : "disabled";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"[Wiki] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)("Automatic screenshot sharing " + status + ".")).method_27692(class_124.field_1060)));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"share").executes(context -> {
            ScreenshotHandler.shareLastScreenshot(false);
            return 1;
        })).then(ClientCommandManager.literal((String)"edit").executes(context -> {
            ScreenshotHandler.shareLastScreenshot(true);
            return 1;
        }))));
        LOGGER.info("Wiki client commands registered");
    }
}

