/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class WikiClientState {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wiki-plugin");
    private static final String CONFIG_FILE = "wiki-plugin-client.properties";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("wiki-plugin-client.properties");
    private static String wikiUrl = null;
    private static String clientToken = null;
    private static boolean autoShareEnabled = false;
    private static boolean shownShareTip = false;
    private static boolean shownAutoShareTip = false;
    private static boolean usedAutoShareCommand = false;

    private static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                Properties props = new Properties();
                props.load(in);
                autoShareEnabled = Boolean.parseBoolean(props.getProperty("auto_share_enabled", "false"));
                LOGGER.info("Loaded client config: autoShare={}", (Object)autoShareEnabled);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load client config", (Throwable)e);
            }
        }
    }

    private static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Properties props = new Properties();
            props.setProperty("auto_share_enabled", String.valueOf(autoShareEnabled));
            try (OutputStream out = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
                props.store(out, "Wiki Plugin Client Configuration");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save client config", (Throwable)e);
        }
    }

    public static String getWikiUrl() {
        return wikiUrl;
    }

    public static void setWikiUrl(String url) {
        wikiUrl = url;
        LOGGER.info("Wiki URL set to: {}", (Object)url);
    }

    public static String getClientToken() {
        return clientToken;
    }

    public static void setClientToken(String token) {
        clientToken = token;
        LOGGER.info("Client token received from server");
    }

    public static boolean isAutoShareEnabled() {
        return autoShareEnabled;
    }

    public static boolean toggleAutoShare() {
        autoShareEnabled = !autoShareEnabled;
        WikiClientState.save();
        return autoShareEnabled;
    }

    public static void setAutoShareEnabled(boolean enabled) {
        autoShareEnabled = enabled;
        WikiClientState.save();
    }

    public static boolean hasShownShareTip() {
        return shownShareTip;
    }

    public static void markShareTipShown() {
        shownShareTip = true;
    }

    public static boolean hasShownAutoShareTip() {
        return shownAutoShareTip;
    }

    public static void markAutoShareTipShown() {
        shownAutoShareTip = true;
    }

    public static boolean hasUsedAutoShareCommand() {
        return usedAutoShareCommand;
    }

    public static void markAutoShareCommandUsed() {
        usedAutoShareCommand = true;
    }

    public static boolean isConfigured() {
        return wikiUrl != null && !wikiUrl.isEmpty() && clientToken != null && !clientToken.isEmpty();
    }

    public static void clearSession() {
        wikiUrl = null;
        clientToken = null;
    }

    static {
        WikiClientState.load();
    }
}

