/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki.client.mixin;

import io.hamiltonian.minecraft.wiki.client.ScreenshotHandler;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_318;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_318.class})
public class ScreenshotRecorderMixin {
    @Inject(method={"method_22690(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/class_276;ILjava/util/function/Consumer;)V"}, at={@At(value="HEAD")})
    private static void onSaveScreenshot(File gameDirectory, String fileName, class_276 framebuffer, int downscaleFactor, Consumer<class_2561> messageReceiver, CallbackInfo ci) {
        File screenshotsDir = new File(gameDirectory, "screenshots");
        new Thread(() -> {
            try {
                Thread.sleep(500L);
                File[] screenshots = screenshotsDir.listFiles((dir, name) -> name.endsWith(".png"));
                if (screenshots != null && screenshots.length > 0) {
                    File latest = screenshots[0];
                    for (File f : screenshots) {
                        if (f.lastModified() <= latest.lastModified()) continue;
                        latest = f;
                    }
                    if (System.currentTimeMillis() - latest.lastModified() < 2000L) {
                        ScreenshotHandler.onScreenshotTaken(latest.toPath());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }
}

