/*
 * Decompiled with CFR 0.152.
 */
package io.hamiltonian.minecraft.wiki.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.hamiltonian.minecraft.wiki.WikiConfig;
import io.hamiltonian.minecraft.wiki.WikiPlugin;
import io.hamiltonian.minecraft.wiki.network.ClientTokenPayload;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class WikiNetworkingServer {
    private static final Gson GSON = new Gson();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();

    public static void register(WikiConfig config) {
        PayloadTypeRegistry.playS2C().register(ClientTokenPayload.ID, ClientTokenPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!config.isConfigured()) {
                WikiPlugin.LOGGER.debug("Server not linked to wiki, not sending client token");
                return;
            }
            class_3222 player = handler.field_14140;
            String playerUuid = player.method_5845();
            String playerName = player.method_5477().getString();
            WikiPlugin.LOGGER.info("Player {} joined, requesting client token", (Object)playerName);
            CompletableFuture.runAsync(() -> {
                try {
                    JsonObject requestJson = new JsonObject();
                    requestJson.addProperty("MinecraftUuid", playerUuid);
                    requestJson.addProperty("Username", playerName);
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(config.getWikiUrl() + "/api/auth/client-token")).header("Content-Type", "application/json").header("Authorization", "Bearer " + config.getServerToken()).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)requestJson))).timeout(Duration.ofSeconds(10L)).build();
                    HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 200) {
                        JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                        String token = json.get("clientToken").getAsString();
                        server.execute(() -> {
                            if (ServerPlayNetworking.canSend((class_3222)player, ClientTokenPayload.ID)) {
                                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientTokenPayload(config.getWikiUrl(), token));
                                WikiPlugin.LOGGER.info("Sent client token to {}", (Object)playerName);
                            } else {
                                WikiPlugin.LOGGER.debug("Player {} doesn't have wiki client mod", (Object)playerName);
                            }
                        });
                    } else {
                        WikiPlugin.LOGGER.error("Failed to get client token for {}: {} {}", new Object[]{playerName, response.statusCode(), response.body()});
                    }
                }
                catch (Exception e) {
                    WikiPlugin.LOGGER.error("Failed to request client token for {}", (Object)playerName, (Object)e);
                }
            });
        });
        WikiPlugin.LOGGER.info("Wiki networking registered (server)");
    }

    public static void sendClientToken(class_3222 player, String wikiUrl, String clientToken) {
        if (ServerPlayNetworking.canSend((class_3222)player, ClientTokenPayload.ID)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientTokenPayload(wikiUrl, clientToken));
            WikiPlugin.LOGGER.debug("Sent client token to {}", (Object)player.method_5477().getString());
        }
    }
}

